/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

class TempFiles {
    private static final Logger LOGGER = Logger.getLogger(TempFiles.class.getName());
    private static final Class<?> CLASS_FILES;
    private static final Class<?> CLASS_PATH;
    private static final Class<?> CLASS_FILE_ATTRIBUTE;
    private static final Class<?> CLASS_FILE_ATTRIBUTES;
    private static final Method METHOD_FILE_TO_PATH;
    private static final Method METHOD_FILES_CREATE_TEMP_FILE;
    private static final Method METHOD_FILES_CREATE_TEMP_FILE_WITHPATH;
    private static final Method METHOD_PATH_TO_FILE;
    private static boolean useJdk6API;

    TempFiles() {
    }

    private static boolean isJdk6() {
        String string = System.getProperty("java.version");
        LOGGER.log(Level.FINEST, "Detected java version = {0}", string);
        return string.startsWith("1.6.");
    }

    private static Class<?> safeGetClass(String string) {
        if (useJdk6API) {
            return null;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.SEVERE, "Exception cought", classNotFoundException);
            LOGGER.log(Level.WARNING, "Class {0} not found. Temp files will be created using old java.io API.", string);
            useJdk6API = true;
            return null;
        }
    }

    private static Method safeGetMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        if (useJdk6API) {
            return null;
        }
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.SEVERE, "Exception cought", noSuchMethodException);
            LOGGER.log(Level.WARNING, "Method {0} not found. Temp files will be created using old java.io API.", string);
            useJdk6API = true;
            return null;
        }
    }

    static Object toPath(File file) throws InvocationTargetException, IllegalAccessException {
        return METHOD_FILE_TO_PATH.invoke(file, new Object[0]);
    }

    static File toFile(Object object) throws InvocationTargetException, IllegalAccessException {
        return (File)METHOD_PATH_TO_FILE.invoke(object, new Object[0]);
    }

    static File createTempFile(String string, String string2, File file) throws IOException {
        if (useJdk6API) {
            LOGGER.log(Level.FINEST, "Jdk6 detected, temp file (prefix:{0}, suffix:{1}) being created using old java.io API.", new Object[]{string, string2});
            return File.createTempFile(string, string2, file);
        }
        try {
            if (file != null) {
                Object object = TempFiles.toPath(file);
                LOGGER.log(Level.FINEST, "Temp file (path: {0}, prefix:{1}, suffix:{2}) being created using NIO API.", new Object[]{file.getAbsolutePath(), string, string2});
                return TempFiles.toFile(METHOD_FILES_CREATE_TEMP_FILE_WITHPATH.invoke(null, object, string, string2, Array.newInstance(CLASS_FILE_ATTRIBUTE, 0)));
            }
            LOGGER.log(Level.FINEST, "Temp file (prefix:{0}, suffix:{1}) being created using NIO API.", new Object[]{string, string2});
            return TempFiles.toFile(METHOD_FILES_CREATE_TEMP_FILE.invoke(null, string, string2, Array.newInstance(CLASS_FILE_ATTRIBUTE, 0)));
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.SEVERE, "Exception caught", illegalAccessException);
            LOGGER.log(Level.WARNING, "Error invoking java.nio API, temp file (path: {0}, prefix:{1}, suffix:{2}) being created using old java.io API.", new Object[]{file != null ? file.getAbsolutePath() : null, string, string2});
            return File.createTempFile(string, string2, file);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.SEVERE, "Exception caught", invocationTargetException);
            LOGGER.log(Level.WARNING, "Error invoking java.nio API, temp file (path: {0}, prefix:{1}, suffix:{2}) being created using old java.io API.", new Object[]{file != null ? file.getAbsolutePath() : null, string, string2});
            return File.createTempFile(string, string2, file);
        }
    }

    static {
        useJdk6API = TempFiles.isJdk6();
        CLASS_FILES = TempFiles.safeGetClass("java.nio.file.Files");
        CLASS_PATH = TempFiles.safeGetClass("java.nio.file.Path");
        CLASS_FILE_ATTRIBUTE = TempFiles.safeGetClass("java.nio.file.attribute.FileAttribute");
        CLASS_FILE_ATTRIBUTES = TempFiles.safeGetClass("[Ljava.nio.file.attribute.FileAttribute;");
        METHOD_FILE_TO_PATH = TempFiles.safeGetMethod(File.class, "toPath", new Class[0]);
        METHOD_FILES_CREATE_TEMP_FILE = TempFiles.safeGetMethod(CLASS_FILES, "createTempFile", String.class, String.class, CLASS_FILE_ATTRIBUTES);
        METHOD_FILES_CREATE_TEMP_FILE_WITHPATH = TempFiles.safeGetMethod(CLASS_FILES, "createTempFile", CLASS_PATH, String.class, String.class, CLASS_FILE_ATTRIBUTES);
        METHOD_PATH_TO_FILE = TempFiles.safeGetMethod(CLASS_PATH, "toFile", new Class[0]);
    }
}

